/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.access.api.AcaUtils;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.hsc.common.util.PIHmcAccessUtils;
import com.ibm.hsc.common.util.PIUserUtils;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class PIHMCUserModify {
    private static final String[] m_validOpts = new String[]{HMCCommandUtils.USER_NAME_PARAM, HMCCommandUtils.TYPE_PARAM, HMCCommandUtils.VALUE_PARAM, "-o", "-r", HMCCommandUtils.HELP_PARAM};
    private String m_login = null;
    private String m_reqType = null;
    private String m_newValue = null;
    private String m_newPassWd = null;
    private AcaClient m_acaCl = new AcaClient(1);
    private String m_assignedType;
    private String m_operation;
    private boolean m_GUIUser = false;
    private int m_rc = 0;

    private boolean verifyCurrentPassword(String string) throws PIHscClientException {
        BufferedReader bufferedReader = null;
        boolean bl = false;
        String string2 = "";
        String string3 = System.getProperty("HMCtty.name");
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        try {
            EExecResult eExecResult;
            if (string3 != null && string3 != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string3));
                string4 = "stty --file=" + string3 + " " + eExecResult.stdout;
                string5 = "stty --file=" + string3 + " -echo";
                bl2 = true;
            }
            Object[] objectArray = new String[]{this.m_login};
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ENTER_OLD_PASSWORD", null, objectArray));
            if (bl2) {
                eExecResult = EExec.Exec(string5);
            }
            string2 = bufferedReader.readLine().trim();
            if (bl2) {
                eExecResult = EExec.Exec((String)string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIUserUtils.validateUserPassword(string, string2);
        return true;
    }

    private void modifyPassword() throws PIHscClientException {
        String[] stringArray;
        int n;
        Object object;
        BufferedReader bufferedReader = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable hashtable = new Hashtable();
        try {
            object = new String[]{this.m_login};
            n = 0;
            stringArray = System.getProperty("HMCRealUser.name");
            if (!(PIUserUtils.isHMCSuperUser((String)stringArray) || this.m_acaCl.hasSuperRole((String)stringArray) || this.m_GUIUser)) {
                this.verifyCurrentPassword(this.m_login);
            }
            if (this.m_newValue != null) {
                string = this.m_newValue;
                string2 = this.m_newValue;
            } else {
                if (!PIUserUtils.getUserPassword(this.m_login, hashtable)) {
                    throw new PIHscClientException("8014", "PIHscCmdLineBundle", "ERROR_READING_PASSWORD");
                }
                string = (String)hashtable.get("_Passwd_PROP");
                string2 = (String)hashtable.get("_RePasswd_PROP");
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            throw new PIHscClientException("8014", "PIHscCmdLineBundle", "ERROR_READING_PASSWORD");
        }
        PIUserUtils.validatePasswordInput(this.m_login, string, string2);
        object = PIUserUtils.buildModifyEncrptPasswd(this.m_login, string);
        n = 0;
        try {
            stringArray = Runtime.getRuntime().exec((String)object);
            n = stringArray.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringArray = new String[3];
        if (n != 0) {
            PIUserUtils.logSysEvent((short)2105, stringArray);
            if (n >= 1) {
                throw new PIHscClientException("233D", "PIHscCmdLineBundle", "USER_SET_PASSWORD_ERROR");
            }
            return;
        }
        PIUserUtils.storePasswdIfHscroot(this.m_login, string);
        PIUserUtils.logSysEvent((short)2105, stringArray);
    }

    private void redefineAssignment() throws PIHscClientException {
        String[] stringArray;
        AccUtils.DBG("in redefineAssignment");
        AccUtils.DBG("m_login=" + this.m_login);
        AccUtils.DBG("m_assignedType=" + this.m_assignedType);
        AccUtils.DBG("m_operation=" + this.m_operation);
        AccUtils.DBG("m_newValue=" + this.m_newValue);
        int n = 1;
        if (this.m_assignedType.equals("resourcerole")) {
            stringArray = new String[2];
            stringArray[0] = this.m_newValue;
            n = this.m_acaCl.RedefineUserAssignment(this.m_login, null, stringArray);
            if (n != 0) {
                throw new PIHscClientException("232D", "PIHscCmdLineBundle", "USER_MODIFY_FAILED");
            }
        }
        if (this.m_assignedType.equals("resource")) {
            AccUtils.DBG("redefineAssignment - resource");
            stringArray = new String[2];
            stringArray[0] = this.m_newValue;
            AccUtils.DBG("rsrc=" + this.m_newValue);
            n = this.m_acaCl.RedefineUserAssignment(this.m_login, stringArray, null);
        }
    }

    private void modifyAssignment() throws PIHscClientException {
        String[] stringArray;
        AccUtils.DBG("In modifyAssignment");
        AccUtils.DBG("m_login=" + this.m_login);
        AccUtils.DBG("m_assignedType=" + this.m_assignedType);
        AccUtils.DBG("m_operation=" + this.m_operation);
        AccUtils.DBG("m_newValue=" + this.m_newValue);
        this.m_rc = 1;
        if (this.m_assignedType.equals("resource")) {
            stringArray = new String[]{this.m_newValue};
            if (this.m_operation.equals("a")) {
                if (!this.m_newValue.equals("ALL:")) {
                    String string = this.m_newValue;
                    if (this.m_newValue.indexOf(AcaUtils.ALL_PARTITIONS_TAG) >= 0) {
                        string = PIHmcAccessUtils.createCECInstIDFromAllPartID(this.m_newValue);
                    }
                    if (PIHmcAccessUtils.getUserDefinedName(string) == null) {
                        AccUtils.throwCmdLineSyntaxError(HMCCommandUtils.VALUE_PARAM + " " + string, "INVALID_PARM");
                    }
                }
                this.m_rc = this.m_acaCl.AddUserAssignment(this.m_login, stringArray, null);
            } else {
                this.m_rc = this.m_acaCl.RemoveUserAssignment(this.m_login, stringArray, null);
            }
        } else {
            stringArray = new String[]{this.m_newValue};
            AccUtils.DBG("m_newValue" + this.m_newValue);
            if (this.m_operation.equals("a")) {
                String[] stringArray2 = this.m_acaCl.GetGroups(null);
                boolean bl = false;
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i] == null || !stringArray2[i].equals(this.m_newValue)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    this.m_rc = this.m_acaCl.AddUserAssignment(this.m_login, null, stringArray);
                } else {
                    AccUtils.throwCmdLineSyntaxError(HMCCommandUtils.VALUE_PARAM + " " + this.m_newValue, "INVALID_PARM");
                }
            } else {
                this.m_rc = this.m_acaCl.RemoveUserAssignment(this.m_login, null, stringArray);
            }
        }
        if (this.m_rc != 0) {
            stringArray = AcaClient.GetMessage((int)this.m_rc);
            AccUtils.SHOW((String)stringArray);
        }
    }

    public void performCommand() throws PIHscClientException {
        int n;
        String[] stringArray;
        String string = "";
        String string2 = "";
        String[] stringArray2 = new String[3];
        stringArray2[0] = this.m_login;
        if (this.m_login.equals("hscroot") && !this.m_reqType.equals("passwd")) {
            throw new PIHscClientException("233F", "PIHscCmdLineBundle", "ERROR_ROOT_USER");
        }
        if (this.m_login.equals("root") && !this.m_reqType.equals("passwd")) {
            throw new PIHscClientException("233F", "PIHscCmdLineBundle", "ERROR_ROOT_USER");
        }
        if (!PIUserUtils.isHMCUser(this.m_login)) {
            String[] stringArray3 = new String[]{this.m_login};
            throw new PIHscClientException("233E", "PIHscCmdLineBundle", "USER_NOT_FOUND", stringArray3, new Throwable());
        }
        String string3 = "";
        String[] stringArray4 = this.m_acaCl.GetRoles("");
        string3 = PIUserUtils.arrayToString(stringArray4);
        String string4 = "";
        if (this.m_reqType.equals("taskrole")) {
            if (!this.m_acaCl.isValidRole(this.m_newValue)) {
                String[] stringArray5 = new String[]{HMCCommandUtils.VALUE_PARAM + " " + this.m_newValue, string3};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray5, new Throwable());
            }
            stringArray = new String[]{this.m_newValue};
            n = this.m_acaCl.RedefineUser(this.m_login, stringArray, 1);
            if (n != 0) {
                PIUserUtils.logSysEvent((short)2104, stringArray2);
                String string5 = AcaClient.GetMessage((int)n);
                AccUtils.DBG("rc=" + n + " acmMsg=" + string5);
                throw new PIHscClientException("232D", "PIHscCmdLineBundle", "USER_MODIFY_FAILED");
            }
            string4 = PIUserUtils.buildModifyCmd("", this.m_login, "", "", stringArray, null);
        } else if (this.m_reqType.equals("desc")) {
            this.m_newValue = PIUserUtils.isValidUserDescription(this.m_newValue);
            if (this.m_newValue == null || this.m_newValue.length() <= 0) {
                this.m_newValue = "HMC User";
            }
            string4 = PIUserUtils.buildModifyCmd("", this.m_login, "", this.m_newValue, null, null);
        } else if (this.m_reqType.equals("name")) {
            if (this.m_login.equals(this.m_newValue)) {
                return;
            }
            PIUserUtils.validateLogin(this.m_newValue);
            string4 = PIUserUtils.buildModifyCmd(this.m_newValue, this.m_login, "", "", null, null);
        } else {
            if (this.m_reqType.equals("passwd")) {
                this.modifyPassword();
                return;
            }
            if (this.m_reqType.equals("pwage")) {
                PIUserUtils.setPasswdExpiration(this.m_login, this.m_newValue);
            } else {
                if (this.m_reqType.equals("assign")) {
                    if (this.m_GUIUser) {
                        this.redefineAssignment();
                    } else {
                        this.modifyAssignment();
                    }
                    return;
                }
                String[] stringArray6 = new String[2];
                stringArray6[0] = HMCCommandUtils.VALUE_PARAM;
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray6, new Throwable());
            }
        }
        stringArray2[1] = this.m_newValue;
        stringArray2[2] = string3;
        EExecResult eExecResult = EExec.Exec((String)string4);
        PIUserUtils.printExecResult(eExecResult);
        if (eExecResult.rc != 0) {
            PIUserUtils.logSysEvent((short)2104, stringArray2);
            throw new PIHscClientException("232D", "PIHscCmdLineBundle", "USER_MODIFY_FAILED");
        }
        if (this.m_reqType.equals("name") && (n = this.m_acaCl.RedefineUser(this.m_login, stringArray = new String[]{this.m_newValue}, 5)) != 0) {
            PIUserUtils.logSysEvent((short)2104, stringArray2);
            throw new PIHscClientException("232D", "PIHscCmdLineBundle", "USER_MODIFY_FAILED");
        }
        PIUserUtils.logSysEvent((short)2103, stringArray2);
    }

    private void throwRequiredParameter(String string) throws PIHscClientException {
        String[] stringArray = new String[]{string};
        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, new Throwable());
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException {
        String[] stringArray;
        Object var2_2 = null;
        String string = AccUtils.validateCmdOptions(m_validOpts, hashMap);
        if (string != null && string.length() > 0) {
            AccUtils.throwCmdLineSyntaxError(string, "INVALID_PARM");
        }
        this.m_login = (String)hashMap.get(HMCCommandUtils.USER_NAME_PARAM);
        if (this.m_login != null) {
            this.m_login = this.m_login.trim();
        }
        this.m_reqType = (String)hashMap.get(HMCCommandUtils.TYPE_PARAM);
        if (this.m_reqType != null) {
            this.m_reqType = this.m_reqType.trim().toLowerCase();
        }
        this.m_newValue = (String)hashMap.get(HMCCommandUtils.VALUE_PARAM);
        if (this.m_newValue != null) {
            this.m_newValue = this.m_newValue.trim();
        }
        this.m_operation = (String)hashMap.get("-o");
        if (this.m_operation != null) {
            this.m_operation = this.m_operation.trim();
        }
        this.m_assignedType = (String)hashMap.get("-r");
        if (this.m_assignedType != null) {
            this.m_assignedType = this.m_assignedType.trim();
        }
        if (this.m_reqType == null || this.m_reqType.length() <= 0) {
            this.throwRequiredParameter("-t");
        }
        String string2 = System.getProperty("HMCRealUser.name");
        AccUtils.DBG("realUserName = " + string2);
        if (!this.m_GUIUser && !this.m_acaCl.hasSuperRole(string2)) {
            if (this.m_reqType.equals("passwd")) {
                if (!this.m_login.equals(string2)) {
                    String string3 = AcaClient.GetMessage((int)11);
                    throw new PIHscClientException(string3);
                }
            } else {
                String string4 = AcaClient.GetMessage((int)11);
                throw new PIHscClientException(string4);
            }
        }
        if (this.m_reqType.equals("assign")) {
            if (this.m_operation == null || !this.m_operation.equals("a") && !this.m_operation.equals("r")) {
                this.throwRequiredParameter("-o");
            }
            if (this.m_assignedType == null || !this.m_assignedType.equals("resource") && !this.m_assignedType.equals("resourcerole")) {
                this.throwRequiredParameter("-r");
            }
        }
        if (this.m_login == null || this.m_reqType == null || this.m_newValue == null && !this.m_reqType.equals("passwd")) {
            stringArray = HMCCommandUtils.USER_NAME_PARAM + ", " + HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.VALUE_PARAM;
            this.throwRequiredParameter((String)stringArray);
        }
        if (!(this.m_reqType.equals("taskrole") || this.m_reqType.equals("desc") || this.m_reqType.equals("passwd") || this.m_reqType.equals("name") || this.m_reqType.equals("pwage") || this.m_reqType.equals("assign"))) {
            stringArray = new String[]{HMCCommandUtils.TYPE_PARAM + " " + this.m_reqType, "taskrole, desc, passwd, name"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, new Throwable());
        }
        if (this.m_reqType.equals("pwage") && !PIUserUtils.isValidPasswordAge(this.m_newValue)) {
            stringArray = HMCCommandUtils.VALUE_PARAM + " " + this.m_newValue;
            AccUtils.throwInvalidParm((String)stringArray);
        }
    }

    public void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "HMCUSER_MODIFY_HELP"));
    }

    public int modifyUserFromGUI(String[] stringArray) throws PIHscClientException {
        this.m_GUIUser = true;
        return this.modifyUser(stringArray);
    }

    public int modifyUserFromGUI(Locale locale, String[] stringArray) throws Exception {
        this.m_GUIUser = true;
        try {
            int n = this.modifyUser(stringArray);
            return n;
        }
        catch (PIHscClientException pIHscClientException) {
            pIHscClientException.printStackTrace();
            String string = HSCResourceBundleUtil.getMessage(locale, pIHscClientException.getBundleName(), pIHscClientException.getMsgId(), "", pIHscClientException.getArgs(), true);
            throw new Exception(string);
        }
    }

    public int modifyUser(String[] stringArray) throws PIHscClientException {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (0 == stringArray.length) {
            this.printHelp();
            return 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            arrayList.add(string);
            if (!string.equals(HMCCommandUtils.HELP_PARAM)) continue;
            this.printHelp();
            bl = true;
            break;
        }
        if (!bl) {
            HashMap hashMap;
            try {
                hashMap = HMCCommandUtils.parseParameters(arrayList);
            }
            catch (RequiredParameterException requiredParameterException) {
                throw new PIHscClientException(requiredParameterException.getMessage());
            }
            this.mapParameters(hashMap);
            this.performCommand();
        }
        return this.m_rc;
    }

    public static void main(String[] stringArray) {
        String string = null;
        try {
            PIHMCUserModify pIHMCUserModify = new PIHMCUserModify();
            int n = pIHMCUserModify.modifyUser(stringArray);
            if (n != 0) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            string = pIHscClientException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
    }
}

